/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.fw.ntfy.TextBasedEvent;
import com.ibm.hwmca.fw.ntfy.TextField;
import com.ibm.hwmca.fw.ntfy.TextFilter;
import java.io.Serializable;
import java.util.EventObject;
import java.util.StringTokenizer;

public class StringCollectionFilter
extends TextFilter
implements Serializable {
    static final long serialVersionUID = 2768955975814819801L;
    public static final int[] LEGAL_OPS = new int[]{100, 101, 1000, 1001};
    private String[] _operands;

    StringCollectionFilter() {
    }

    public StringCollectionFilter(String name, int op, String operand, TextField field) {
        super(name, op, operand, field);
    }

    public boolean pass(EventObject event) {
        if (!super.pass(event)) {
            return false;
        }
        boolean result = false;
        try {
            String fieldValue = this.getFieldData(((TextBasedEvent)event).getText());
            switch (this._operation) {
                case 100: {
                    result = this._operands[0].compareTo(fieldValue) < 0 && fieldValue.compareTo(this._operands[1]) < 0;
                    break;
                }
                case 101: {
                    result = this._operands[0].compareTo(fieldValue) > 0 || fieldValue.compareTo(this._operands[1]) > 0;
                    break;
                }
                case 1000: {
                    result = this.opIn(fieldValue);
                    break;
                }
                case 1001: {
                    result = !this.opIn(fieldValue);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private boolean opIn(String fieldValue) {
        for (int i = 0; i < this._operands.length; ++i) {
            if (!fieldValue.equals(this._operands[i])) continue;
            return true;
        }
        return false;
    }

    public boolean validateData(int op, String operand) {
        boolean result = false;
        if (StringCollectionFilter.isLegalOp(op, LEGAL_OPS)) {
            try {
                this._operands = this.parseOperand(operand);
                result = StringCollectionFilter.isTertiaryOp(op) && this._operands.length == 2 || StringCollectionFilter.isMultiOp(op);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private String[] parseOperand(String operand) {
        StringTokenizer tokens = new StringTokenizer(operand, operand.substring(0, 1));
        String[] operands = new String[tokens.countTokens()];
        for (int i = 0; i < operands.length; ++i) {
            operands[i] = tokens.nextToken();
        }
        return operands;
    }
}

